/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.annotation.processor.meta;

import io.github.noeppi_noeppi.libx.annotation.meta.SuperChainRequired;
import io.github.noeppi_noeppi.libx.annotation.processor.Classes;
import io.github.noeppi_noeppi.libx.annotation.processor.Processor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class SuperProcessor
extends Processor {
    @Override
    public Class<?>[] getTypes() {
        return new Class[]{SuperChainRequired.class};
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>(super.getSupportedAnnotationTypes());
        set.add(Classes.sourceName("javax.annotation.OverridingMethodsMustInvokeSuper"));
        return set;
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> set = new HashSet<String>(super.getSupportedAnnotationTypes());
        set.add("mod.properties.strict_super");
        return set;
    }

    @Override
    public void run(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean strictSuper = this.options().containsKey("mod.properties.strict_super") && Boolean.parseBoolean(this.options().get("mod.properties.strict_super"));
        for (Element element : roundEnv.getElementsAnnotatedWith(SuperChainRequired.class)) {
            if (element.getKind() == ElementKind.METHOD && !element.getModifiers().contains((Object)Modifier.STATIC) && element.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            this.messager().printMessage(Diagnostic.Kind.ERROR, "@SuperChainRequired can only be used on non-static abstract methods.", element);
        }
        for (TypeElement typeElement : this.getAllProcessedTypes()) {
            for (Element element : typeElement.getEnclosedElements()) {
                List<ExecutableElement> overridden;
                ExecutableElement executable;
                if (element.getKind() != ElementKind.METHOD || !(element instanceof ExecutableElement) || this.hasSuperOverrideAnnotation(executable = (ExecutableElement)element, true) || element.getModifiers().contains((Object)Modifier.ABSTRACT) || element.getModifiers().contains((Object)Modifier.NATIVE) || element.getModifiers().contains((Object)Modifier.FINAL) || !(overridden = this.getAllOverriddenMethods(executable)).stream().anyMatch(ov -> this.hasSuperOverrideAnnotation((ExecutableElement)ov, strictSuper))) continue;
                this.messager().printMessage(strictSuper ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING, "Method should be annotated with @OverridingMethodsMustInvokeSuper.", executable);
            }
        }
    }

    private boolean hasSuperOverrideAnnotation(ExecutableElement element, boolean strict) {
        if (element.getAnnotation(SuperChainRequired.class) != null) {
            return true;
        }
        if (!strict) {
            return false;
        }
        return element.getAnnotationMirrors().stream().anyMatch(mirror -> this.sameErasure(this.forClass("javax.annotation.OverridingMethodsMustInvokeSuper"), mirror.getAnnotationType()));
    }
}

